<?php
session_start();

$servername = "localhost";
$username = "root";
$password = "";
$dbname = "quiz_db";

// Izveido savienojumu
$conn = new mysqli($servername, $username, $password, $dbname);

// Pārbauda savienojumu
if ($conn->connect_error) {
    die("Savienojums neizdevās: " . $conn->connect_error);
}

// Izgūst lietotājvārdu un paroli no POST pieprasījuma
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $username = $_POST['username'];
    $password = $_POST['password'];

    // Sagatavo SQL paziņojumu, lai iegūtu lietotāja datus pēc lietotājvārda
    $sql = "SELECT * FROM users WHERE username = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $username);
    $stmt->execute();
    $result = $stmt->get_result();

    $errors = [];

    if ($result->num_rows > 0) {
        // Izgūst lietotāja datus
        $user = $result->fetch_assoc();

        // Pārbauda paroli
        if (password_verify($password, $user['password'])) {
            // Sāk sesiju un iestata lietotāja ID un admin statusu
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['is_admin'] = $user['is_admin'];

            if ($user['is_admin']) {
                header('Location: ../html/admin_view.html');
            } else {
                header('Location: ../html/sakumlapa.html');
            }
            exit(); // Aptur tālāku izpildi
        } else {
            $errors['password_error'] = "Nepareiza parole.";
        }
    } else {
        $errors['username_error'] = "Lietotājs ar šādu lietotājvārdu nav atrasts.";
    }

    // Aizver paziņojumu un savienojumu
    $stmt->close();
    $conn->close();

    // Redirect back to the login page with error messages
    if (!empty($errors)) {
        $query = http_build_query($errors);
        header('Location: ../html/login.html?' . $query);
        exit();
    }
} else {
    header('Location: ../html/login.html');
    exit();
}
?>
